<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') exit;

include_once __DIR__ . "/config.php";

$email = $_GET['email'] ?? null;

if (!$email) {
    echo json_encode(["status"=>"error","message"=>"Email is required"]);
    exit;
}

// Fetch tickets with status = 0 (Open)
$stmt = $conn->prepare("SELECT * FROM tickets WHERE email=? AND status=0 ORDER BY Date DESC");
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();

$tickets = [];
while($row = $result->fetch_assoc()){
    $tickets[] = $row;
}

echo json_encode(["status"=>"success","tickets"=>$tickets]);

$stmt->close();
$conn->close();
?>
