<?php
// Simple mail test script
header("Content-Type: text/html");

echo "<h1>🚀 Simple Mail System Test</h1>\n";
echo "<p>Testing direct mail functions...</p>\n";
echo "<hr>\n";

try {
    // Include config
    require_once('config.php');
    echo "<p>✅ Config loaded successfully</p>\n";
    
    // Test email address
    $TEST_EMAIL = 'sagarnandal95@gmail.com';
    $TEST_NAME = 'Sagar Nandal';
    
    echo "<h2>📧 Testing Mail Functions</h2>\n";
    
    // Test 1: Check if mail functions exist
    echo "<h3>Function Availability Check</h3>\n";
    $functions = [
        'sendWelcomeEmail',
        'sendPasswordResetEmail',
        'sendAccountVerificationEmail',
        'sendKYCApprovalEmail',
        'sendDepositConfirmationEmail'
    ];
    
    foreach ($functions as $func) {
        if (function_exists($func)) {
            echo "<p>✅ $func - Available</p>\n";
        } else {
            echo "<p>❌ $func - Not Available</p>\n";
        }
    }
    
    // Test 2: Check mail system class
    echo "<h3>Mail System Class Check</h3>\n";
    if (function_exists('getMailSystem')) {
        echo "<p>✅ getMailSystem function available</p>\n";
        $mailSystem = getMailSystem();
        echo "<p>✅ Mail system instance created: " . get_class($mailSystem) . "</p>\n";
    } else {
        echo "<p>❌ getMailSystem function not available</p>\n";
    }
    
    // Test 3: Send a simple welcome email
    echo "<h3>Welcome Email Test</h3>\n";
    if (function_exists('sendWelcomeEmail')) {
        $result = sendWelcomeEmail($TEST_EMAIL, $TEST_NAME);
        echo "<div style='background: #f0f8ff; padding: 10px; margin: 10px 0; border-left: 4px solid #007cba;'>\n";
        echo "<strong>Welcome Email Result:</strong><br>\n";
        echo "<pre>" . print_r($result, true) . "</pre>\n";
        echo "</div>\n";
    } else {
        echo "<p>❌ sendWelcomeEmail function not available</p>\n";
    }
    
    // Test 4: Send password reset email
    echo "<h3>Password Reset Email Test</h3>\n";
    if (function_exists('sendPasswordResetEmail')) {
        $resetLink = "http://localhost:8000/reset-password?token=" . bin2hex(random_bytes(16));
        $result = sendPasswordResetEmail($TEST_EMAIL, $TEST_NAME, $resetLink);
        echo "<div style='background: #f8d7da; padding: 10px; margin: 10px 0; border-left: 4px solid #dc3545;'>\n";
        echo "<strong>Password Reset Email Result:</strong><br>\n";
        echo "<pre>" . print_r($result, true) . "</pre>\n";
        echo "</div>\n";
    } else {
        echo "<p>❌ sendPasswordResetEmail function not available</p>\n";
    }
    
    // Test 5: Direct mail system test
    echo "<h3>Direct Mail System Test</h3>\n";
    if (isset($mailSystem)) {
        try {
            $result = $mailSystem->sendKYCApproved($TEST_EMAIL, $TEST_NAME);
            echo "<div style='background: #d4edda; padding: 10px; margin: 10px 0; border-left: 4px solid #28a745;'>\n";
            echo "<strong>KYC Approval Email Result:</strong><br>\n";
            echo "<pre>" . print_r($result, true) . "</pre>\n";
            echo "</div>\n";
        } catch (Exception $e) {
            echo "<p style='color: red;'>❌ Mail system test failed: " . $e->getMessage() . "</p>\n";
        }
    }
    
    echo "<hr>\n";
    echo "<div style='background: #fff3cd; padding: 15px; margin: 20px 0; border-radius: 5px;'>\n";
    echo "<h3>📧 Email Delivery Check</h3>\n";
    echo "<p>Please check the email inbox for <strong>$TEST_EMAIL</strong> to verify that emails were delivered successfully.</p>\n";
    echo "</div>\n";
    
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Error: " . $e->getMessage() . "</p>\n";
    echo "<p>Stack trace:</p>\n";
    echo "<pre>" . $e->getTraceAsString() . "</pre>\n";
}
?>