<?php
// test_mail.php - Example usage of the ZForex Mail System

require_once 'mail_system.php';

// Example 1: Send registration verification email
function testRegisterVerification() {
    $mailer = new ZForexMailer();
    
    $result = $mailer->sendRegisterVerification(
        'user@example.com',
        'John Doe',
        'https://yoursite.com/verify?token=abc123'
    );
    
    if ($result['success']) {
        echo "✅ Registration verification email sent successfully\n";
    } else {
        echo "❌ Failed to send registration verification email: " . $result['message'] . "\n";
    }
}

// Example 2: Send login credentials after verification
function testLoginCredentials() {
    $mailer = new ZForexMailer();
    
    $result = $mailer->sendLoginCredentials(
        'user@example.com',
        'John Doe',
        'TempPassword123',
        'https://yoursite.com/login'
    );
    
    if ($result['success']) {
        echo "✅ Login credentials email sent successfully\n";
    } else {
        echo "❌ Failed to send login credentials email: " . $result['message'] . "\n";
    }
}

// Example 3: Send login alert
function testLoginAlert() {
    $mailer = new ZForexMailer();
    
    $result = $mailer->sendLoginAlert(
        'user@example.com',
        'John Doe',
        date('Y-m-d H:i:s'),
        '192.168.1.1',
        'Chrome on Windows'
    );
    
    if ($result['success']) {
        echo "✅ Login alert email sent successfully\n";
    } else {
        echo "❌ Failed to send login alert email: " . $result['message'] . "\n";
    }
}

// Example 4: Send live account opened notification
function testLiveAccountOpened() {
    $mailer = new ZForexMailer();
    
    $result = $mailer->sendLiveAccountOpened(
        'user@example.com',
        'John Doe',
        'MT5-123456',
        'Standard',
        '1:500',
        'USD'
    );
    
    if ($result['success']) {
        echo "✅ Live account opened email sent successfully\n";
    } else {
        echo "❌ Failed to send live account opened email: " . $result['message'] . "\n";
    }
}

// Example 5: Send KYC upload confirmation
function testKYCUpload() {
    $mailer = new ZForexMailer();
    
    $result = $mailer->sendKYCUpload(
        'user@example.com',
        'John Doe',
        'KYC-REF-' . uniqid()
    );
    
    if ($result['success']) {
        echo "✅ KYC upload email sent successfully\n";
    } else {
        echo "❌ Failed to send KYC upload email: " . $result['message'] . "\n";
    }
}

// Example 6: Send deposit request notification
function testDepositRequest() {
    $mailer = new ZForexMailer();
    
    $result = $mailer->sendDepositRequest(
        'user@example.com',
        'John Doe',
        '1000',
        'USD',
        'Bank Transfer',
        'TXN-' . uniqid()
    );
    
    if ($result['success']) {
        echo "✅ Deposit request email sent successfully\n";
    } else {
        echo "❌ Failed to send deposit request email: " . $result['message'] . "\n";
    }
}

// Example 7: Send withdrawal OTP
function testWithdrawalOTP() {
    $mailer = new ZForexMailer();
    
    $result = $mailer->sendWithdrawalOTP(
        'user@example.com',
        'John Doe',
        '123456',
        '500',
        'USD',
        'Bank Account ending in 1234'
    );
    
    if ($result['success']) {
        echo "✅ Withdrawal OTP email sent successfully\n";
    } else {
        echo "❌ Failed to send withdrawal OTP email: " . $result['message'] . "\n";
    }
}

// Example 8: Send password reset email
function testPasswordReset() {
    $mailer = new ZForexMailer();
    
    $result = $mailer->sendPasswordReset(
        'user@example.com',
        'John Doe',
        'https://yoursite.com/reset-password?token=xyz789',
        '192.168.1.1'
    );
    
    if ($result['success']) {
        echo "✅ Password reset email sent successfully\n";
    } else {
        echo "❌ Failed to send password reset email: " . $result['message'] . "\n";
    }
}

// Example 9: Using the global function for custom templates
function testCustomTemplate() {
    $result = sendZForexMail(
        'user@example.com',
        'John Doe',
        'trade_open',
        [
            'trade_symbol' => 'EURUSD',
            'trade_side' => 'BUY',
            'trade_volume' => '0.1',
            'price' => '1.0850',
            'order_id' => 'ORD-123456',
            'stop_loss' => '1.0800',
            'take_profit' => '1.0900',
            'trading_url' => 'https://yoursite.com/trading'
        ]
    );
    
    if ($result['success']) {
        echo "✅ Trade open email sent successfully\n";
    } else {
        echo "❌ Failed to send trade open email: " . $result['message'] . "\n";
    }
}

// Example 10: Integration with existing code (like in register.php)
function integrateWithRegister($email, $name, $verification_token) {
    // This is how you would integrate it in your register.php file
    require_once 'mail_system.php';
    
    $verification_url = "https://yoursite.com/verify.php?token=" . $verification_token;
    
    $mailer = new ZForexMailer();
    $result = $mailer->sendRegisterVerification($email, $name, $verification_url);
    
    return $result;
}

// Run tests (uncomment to test)
echo "🧪 Testing ZForex Mail System\n";
echo "=============================\n\n";

// Uncomment these lines to test (make sure to update config.php with real SMTP settings first)
/*
testRegisterVerification();
testLoginCredentials();
testLoginAlert();
testLiveAccountOpened();
testKYCUpload();
testDepositRequest();
testWithdrawalOTP();
testPasswordReset();
testCustomTemplate();
*/

echo "\n📝 To use this mail system:\n";
echo "1. Update config.php with your SMTP settings\n";
echo "2. Install PHPMailer: composer require phpmailer/phpmailer\n";
echo "3. Include mail_system.php in your files\n";
echo "4. Use the ZForexMailer class or global sendZForexMail() function\n\n";

echo "📧 Available email templates:\n";
echo "- register_verification\n";
echo "- after_verify_credentials\n";
echo "- login_alert\n";
echo "- open_live_account\n";
echo "- kyc_upload\n";
echo "- kyc_approved\n";
echo "- deposit_request_submitted\n";
echo "- deposit_approved\n";
echo "- otp_withdrawal\n";
echo "- withdrawal_request_submitted\n";
echo "- withdrawal_approved\n";
echo "- ib_commission_withdrawal\n";
echo "- referral_registration\n";
echo "- trade_open\n";
echo "- trade_close\n";
echo "- daily_trade_summary\n";
echo "- password_reset\n";
echo "- password_changed\n";
echo "- profile_updated\n";
echo "- deposit_failed\n";
echo "- withdrawal_rejected\n";
echo "- monthly_statement\n";

?>